/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.chimetojmol;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ChimePanel
extends JPanel
implements ItemListener,
ActionListener {
    private JTextField chimePath;
    private JButton goButton;
    private JButton browseButton;
    private JTextArea logArea;
    private JScrollPane logScrollPane;
    private JFileChooser chooser = new JFileChooser();
    private File oldDir;
    private List<File> pages;
    private int nDir;
    private int nFiles;
    private Checkbox checkSubs;
    private Checkbox checkFilenames;
    private Checkbox checkSigned;
    private boolean doSubdirectories;
    private boolean doFixFilenames;
    private boolean doUseSigned;
    private File myDir;
    private String rootDir;
    private static Pattern embed1 = Pattern.compile("<embed", 2);
    private static Pattern embed2 = Pattern.compile("</embed", 2);

    ChimePanel() {
        this.chooser.setCurrentDirectory(new File("."));
        this.myDir = this.chooser.getCurrentDirectory();
        this.chooser.setDialogTitle("Select a Directory");
        this.chooser.setFileSelectionMode(1);
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.setLayout(new BorderLayout());
        this.chimePath = new JTextField(50);
        this.chimePath.addActionListener(this);
        this.chimePath.setText("c:/temp/Teaching");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Directory containing Chime-based HTML pages to convert"));
        jPanel.add("West", this.chimePath);
        this.browseButton = new JButton("browse...");
        this.browseButton.addActionListener(this);
        jPanel.add("East", this.browseButton);
        this.add("North", jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.checkSubs = new Checkbox("include subdirectories");
        this.checkSubs.addItemListener(this);
        this.checkFilenames = new Checkbox("fix file name case");
        this.checkFilenames.addItemListener(this);
        this.checkSigned = new Checkbox("use signed applet");
        this.checkSigned.addItemListener(this);
        jPanel2.add("North", this.checkSubs);
        jPanel2.add("Center", this.checkFilenames);
        jPanel2.add("South", this.checkSigned);
        this.add("Center", jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        jPanel4.setSize(30, 10);
        this.goButton = new JButton("Convert Page(s)");
        this.goButton.addActionListener(this);
        jPanel4.add(this.goButton);
        jPanel3.add("North", jPanel4);
        this.logArea = new JTextArea(30, 20);
        this.logArea.setMargin(new Insets(5, 5, 5, 5));
        this.logArea.setEditable(false);
        this.logScrollPane = new JScrollPane(this.logArea);
        this.logScrollPane.setBorder(BorderFactory.createTitledBorder("0 pages"));
        jPanel3.add("South", this.logScrollPane);
        this.add("South", jPanel3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.goButton) {
            this.doGo();
        } else if (object == this.browseButton) {
            this.doBrowse();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        int n = itemEvent.getStateChange();
        if (object == this.checkSubs) {
            this.doSubdirectories = n == 1;
            this.getFileList();
        }
        if (object == this.checkFilenames) {
            boolean bl = this.doFixFilenames = n == 1;
        }
        if (object == this.checkSigned) {
            this.doUseSigned = n == 1;
        }
    }

    private void log(String string) {
        this.logArea.setText(this.logArea.getText() + string + "\n");
    }

    void getFileList() {
        this.logArea.setText("");
        this.pages = new ArrayList<File>();
        String string = this.chimePath.getText();
        string = string.replace('\\', '/');
        while (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() < 4) {
            return;
        }
        this.oldDir = new File(string);
        try {
            this.copyDirectory("", this.oldDir, new File(this.oldDir + "_jmol"), true);
        }
        catch (IOException iOException) {
            this.log(iOException.getMessage());
        }
    }

    private void doGo() {
        this.getFileList();
        try {
            this.copyDirectory("", this.oldDir, new File(this.oldDir + "_jmol"), false);
        }
        catch (IOException iOException) {
            this.logArea.setText(iOException.getMessage());
        }
    }

    private void doBrowse() {
        if (this.chooser.showOpenDialog(this) == 0) {
            String string = this.chooser.getSelectedFile().toString();
            this.chimePath.setText(string);
            this.getFileList();
        }
    }

    private void copyDirectory(String string, File file, File file2, boolean bl) throws IOException {
        if (string.equals("")) {
            this.nFiles = 0;
            this.nDir = 0;
            this.rootDir = file2.getAbsolutePath();
            if (!bl) {
                ChimePanel.deleteDirectory(file2);
                file2.mkdir();
                this.addJmolFiles(this.rootDir);
            }
        } else if (this.doFixFilenames) {
            file2 = new File(this.fixFileName(file2));
        }
        if (file.isDirectory()) {
            if (!this.doSubdirectories && !string.equals("")) {
                return;
            }
            ++this.nDir;
            if (!file2.exists() && !bl) {
                file2.mkdir();
            }
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                this.copyDirectory(string.equals("") ? "." : (string.equals(".") ? ".." : string + "/.."), new File(file, stringArray[i]), new File(file2, stringArray[i]), bl);
            }
        } else {
            if (!this.copyFile(string, file, file2, bl)) {
                this.log("Hmm..." + file + " --> " + file2);
            }
            ++this.nFiles;
        }
        this.showProgress();
    }

    private void addJmolFiles(String string) {
        File file = this.myDir;
        if (!new File(file, "Jmol.js").exists()) {
            file = this.oldDir;
        }
        File file2 = new File(string);
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string2.equals("Jmol.js") && (!string2.startsWith("JmolApplet") || !string2.endsWith(".jar") || this.doUseSigned != string2.indexOf("AppletSigned") >= 0)) continue;
            this.justTransferFile(new File(file, string2), new File(file2, string2), null);
        }
        this.transferResource(file, "chimebtn16.bin", file2, "chimebtn16.png");
        this.transferResource(file, "ChimeToJmol.js", file2, "ChimeToJmol.js");
    }

    private void transferResource(File file, String string, File file2, String string2) {
        File file3 = new File(file, string);
        File file4 = new File(file2, string2);
        if (file3.exists()) {
            this.justTransferFile(file3, file4, null);
        } else {
            this.justTransferFile(null, file4, ChimePanel.getResourceStream(string));
        }
    }

    public static boolean deleteDirectory(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return false;
        }
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (!(file2.isDirectory() ? !ChimePanel.deleteDirectory(file2) : !file2.delete())) continue;
                return false;
            }
        }
        return file.delete();
    }

    private String fixFileName(File file) {
        return (this.rootDir + "/" + file.getAbsolutePath().substring(this.rootDir.length()).toLowerCase()).replace('\\', '/');
    }

    private void showProgress() {
        String string = this.pages.size() + " pages/" + (this.nDir > 1 ? this.nDir + " directories/" : "") + this.nFiles + " files";
        this.logScrollPane.setBorder(BorderFactory.createTitledBorder(string));
    }

    private boolean copyFile(String string, File file, File file2, boolean bl) {
        String string2 = file.getName().toLowerCase();
        if (string2.endsWith(".htm") || string2.endsWith(".html")) {
            if (bl) {
                this.pages.add(file);
                this.log(file.getAbsolutePath());
                return true;
            }
            this.log("---\n" + file.getAbsolutePath() + " --> " + file2.getAbsolutePath());
            return this.processFile(string, file, file2, true, true);
        }
        if (bl) {
            return true;
        }
        if (string2.endsWith(".spt")) {
            this.log("---\n" + file.getAbsolutePath() + " --> " + file2.getAbsolutePath());
            return this.processFile(string, file, file2, false, true);
        }
        return this.justTransferFile(file, file2, null);
    }

    private boolean justTransferFile(File file, File file2, InputStream inputStream) {
        try {
            int n;
            if (file != null) {
                inputStream = new FileInputStream(file);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean processFile(String string, File file, File file2, boolean bl, boolean bl2) {
        String string2 = this.getFileContents(file);
        if (string2 == null) {
            this.log("?error reading " + file.getAbsolutePath());
            return false;
        }
        if (this.doFixFilenames) {
            string2 = this.fixFileNames(string2, bl);
        }
        if (bl && string2.indexOf("Jmol.js") < 0) {
            String string3 = "\n<script type=\"text/javascript\"";
            String string4 = string3 + " src=\"" + string + "/Jmol.js\"></script>";
            string4 = string4 + string3 + " src=\"" + string + "/ChimeToJmol.js\"></script>";
            string4 = string4 + string3 + ">jmolInitialize('" + string + "'," + this.doUseSigned + ");chimebtn = '" + string + "/chimebtn16.png';</script>";
            int n = string2.toLowerCase().indexOf("<head>");
            if (n < 0) {
                string2 = "<head></head>" + string2;
                n = 0;
            }
            string2 = string2.substring(0, n + 6) + string4 + "\n" + string2.substring(n + 6);
            string2 = embed1.matcher(string2).replaceAll("<xembed");
            string2 = embed2.matcher(string2).replaceAll("</xembed");
        }
        if (bl2) {
            string2 = this.fixChime(string2, bl);
        }
        if (!this.putFileContents(file2, string2)) {
            this.log("?error creating " + file2);
            return false;
        }
        return true;
    }

    private String fixFileNames(String string, boolean bl) {
        if (bl) {
            string = this.fixFileNames(string, "src=", '\u0000');
            string = this.fixFileNames(string, "script=", '\u0000');
        }
        if (string.startsWith("load")) {
            string = "\n" + string + "\n";
        }
        string = this.fixFileNames(string, "\nload", '\n');
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String fixFileNames(String string, String string2, char c) {
        int n = -1;
        boolean bl = string2.equals("script=");
        String string3 = string.toLowerCase();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        while ((n = string3.indexOf(string2, n + 1)) >= 0) {
            if (c == '\n') {
                n3 = string.indexOf(c, n + 1);
            } else {
                boolean bl2;
                n3 = n + string2.length();
                if (n3 == string.length()) break;
                boolean bl3 = string.charAt(n3) == '\"';
                boolean bl4 = string.charAt(n3) == '\'';
                boolean bl5 = bl2 = !bl3 && !bl4;
                if (bl3 || bl4) {
                    ++n3;
                }
                if (bl2) {
                    while (n3 < string.length() && Character.isWhitespace(string.charAt(n3))) {
                        ++n3;
                    }
                }
                block7: while (!(n3 >= string.length() || bl2 && Character.isWhitespace(string.charAt(n3)))) {
                    switch (string.charAt(n3)) {
                        case '\"': {
                            if (!bl3) break;
                            break block7;
                        }
                        case '\'': {
                            if (!bl4) break;
                            break block7;
                        }
                        case '>': {
                            break block7;
                        }
                    }
                    ++n3;
                }
            }
            String string4 = bl ? this.fixFileNames(string.substring(n, n3).replace(';', '\n'), false).replace('\n', ';') : string3.substring(n, n3);
            this.log(string.substring(n, n3) + " --> " + string4);
            stringBuffer.append(string.substring(n2, n)).append(string4);
            n2 = n3;
        }
        stringBuffer.append(string.substring(n2, string.length()));
        return stringBuffer.toString();
    }

    private String fixChime(String string, boolean bl) {
        return string;
    }

    private String getFileContents(File file) {
        StringBuffer stringBuffer = new StringBuffer(8192);
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string).append('\n');
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return stringBuffer.toString();
    }

    private boolean putFileContents(File file, String string) {
        try {
            FileWriter fileWriter = new FileWriter(file, false);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string);
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    static InputStream getResourceStream(String string) {
        URL uRL = null;
        string = "org/openscience/chimetojmol/" + string;
        try {
            uRL = ClassLoader.getSystemResource(string);
            if (uRL == null) {
                return null;
            }
            return (InputStream)uRL.getContent();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

