/*
################################################################################
##                Funktionen                  ##
################################################################################
*/

function markiere_alles() {
    document.getElementById('editierbereich').select();
}

function einfuegen(zeichen) {
    var gesamttext=document.getElementById('editierbereich').value;
    var neuer_text=erzeuge_neuen_text(gesamttext, aktuelle_cursorposition, zeichen);
    document.getElementById('editierbereich').value=neuer_text;
    cursor_setzen(aktuelle_cursorposition);
}
        
function erzeuge_neuen_text(gesamttext, aktuelle_cursorposition, zeichen) {
    var neuer_text=gesamttext.substr(0, aktuelle_cursorposition)+zeichen+gesamttext.substr(aktuelle_cursorposition, gesamttext.length);
    return neuer_text;
}

function cursor_setzen(aktuelle_cursorposition) {
    // für IE
    if(typeof document.selection != 'undefined') {
        var bereich=document.getElementById('editierbereich').createTextRange();
        bereich.move('character', aktuelle_cursorposition+1);
        bereich.select();
    // für Gecko basierte Browser
    } else if (typeof document.getElementById('editierbereich').selectionStart != 'undefined') {
        document.getElementById('editierbereich').focus();
        document.getElementById('editierbereich').setSelectionRange(aktuelle_cursorposition+1, aktuelle_cursorposition+1);
}
    //document.getElementById('editierbereich').focus();
}

function speichern() {
    var gesamttext=document.getElementById('editierbereich').value;
    // Quelle: http://en.wikipedia.org/wiki/Data_URI
    /* Variante 1: Nachteil: Erzeugt eine Datei mit der Endung .bin.part
                   Vorteil:  Sie wird direkt zum Download angeboten*/
    //var uriContent='data:application/octet-stream,'+encodeURIComponent(gesamttext);
    /* Variante 2: Vorteil:  Die Datei hat gar keine Standardendung, .txt kann vorgegeben werden
                   Nachteil: Je nach Browsereinstellungen wird die Textdatei im neuen Browserfenster
                             geöffnet und muss manuell heruntergeladen werden.*/
    var uriContent='data:text/plain;charset=utf-8,'+encodeURIComponent(gesamttext);
    var neues_druckvorschaufenster=window.open(uriContent,'Druckansicht');
}

// Globaler Startwert der Cursorposition
var aktuelle_cursorposition=0;

function speichere_aktuelle_cursorposition() {
    // für IE
    if(typeof document.selection != 'undefined') {
        alert('Benutze bitte einen Gecko oder Webkit basierten Browser wie z.B. Mozilla Firefox, Google Chrome oder Apples Safari');
        aktuelle_cursorposition=document.selection.createRange()[0];
    } 
    // für Gecko basierte Browser
    else if (typeof document.getElementById('editierbereich').selectionStart != 'undefined') {
        aktuelle_cursorposition=document.getElementById('editierbereich').selectionStart;
    }
}

function lade_seite() {
    document.forms['SF'].elements['SF_auswahl'].options[0].selected="selected";
    hole_aktuellen_index('SF', 'SF_auswahl');
    document.forms['ST'].elements['ST_auswahl'].options[0].selected="selected";
    hole_aktuellen_index('ST', 'ST_auswahl');
    document.forms['RT'].elements['RT_auswahl'].options[0].selected="selected";
    hole_aktuellen_index('RT', 'RT_auswahl');
    markiere_alles();
}

function hole_aktuellen_index(auswahlname, optionname) {
    if (auswahlname == 'SF') {
        var beispiele=summenformeln;
    } else if (auswahlname == 'ST') {
        var beispiele=strukturformeln;
    } else if (auswahlname == 'RT') {
        var beispiele=reaktionstypen;
    }
    var schluessel=String(document.forms[auswahlname].elements[optionname].value);
    //var zeichenkette=strip(beispiele[schluessel]);
    var zeichenkette=beispiele[schluessel];
    var verschiebung=zeichenkette.length;
    einfuegen(zeichenkette);
    aktuelle_cursorposition=aktuelle_cursorposition+verschiebung;
    cursor_setzen(aktuelle_cursorposition-1);
}

function strip(zeichenkette) {
  return zeichenkette.replace (/^\s+/, '').replace (/\s+$/, '');
}

function zeige_icon(abbildung) {
    var canvas=document.getElementById('zeichenflaeche');
    var context=canvas.getContext('2d');
    context.drawImage(abbildung, 1, 1);
}

/*******************************************************************************
****                              PNG-Export                                ****
*******************************************************************************/
function exportiere() {
    var zeichenkette=document.getElementById('editierbereich').value;
    var schriftgrad=16;
    var canvas=document.getElementById('zeichenflaeche_versteckt');
    /* Canvas-Inhalt löschen */
    canvas.setAttribute('width', 700, 0);
    canvas.setAttribute('height', 500, 0);
    var context=canvas.getContext('2d');
    context.clearRect(0, 0, 700, 500);
    var zeilen=new Array();
    zeilen=zeichenkette.split('\n');
    /* Canvas-Größe anpassen */
    /* Teil 1: Neue Höhe */
    // Abstand nach oben und unten
    var abstand_ou=5;
    // Zeilenzahl
    var zeilenzahl=parseInt(zeilen.length);
    // Zeilenabstand
    var abstand_zeilen=4;
    // Abstand von Links
    var startposition_x=10;
    // Neue Höhe
    var startposition_y=parseInt(schriftgrad)+parseInt(abstand_ou);
    var neue_hoehe=parseInt(startposition_y)+zeilenzahl*(parseInt(schriftgrad)+4)+abstand_ou;
    canvas.setAttribute('height', neue_hoehe, 0);
    /* Teil 2: Neue Breite */
    // Ein Zeichen ist etwa 11 px breit
    var zeichenbreite=11;
    var zeichenzahlen=new Array();
    for (i=0; i < zeilen.length;i++) {
        zeichenzahlen.push(zeilen[i].length);
    }
    zeichenzahlen.sort(Numsort);
    var laengste_zeile=zeichenzahlen[zeichenzahlen.length-1];
    var neue_breite=parseInt(zeichenbreite)*parseInt(laengste_zeile)+2*parseInt(startposition_x);
    //alert('Zeilenzahl='+zeilenzahl+', erste Y-Startposition='+startposition_y+', neue Höhe='+neue_hoehe+', neue Breite='+neue_breite);
    canvas.setAttribute('width', neue_breite, 0);
    /* Neuen Canvas-Context füllen */
    var neuer_context=canvas.getContext('2d');
    neuer_context.fillStyle='black';
    neuer_context.font=schriftgrad+'px monospace'; //DejaVu Sans Mono
    for (i=0; i < zeilen.length; i++) {
        //alert(zeilen[i]);
        neuer_context.fillText(zeilen[i], startposition_x, startposition_y);
        startposition_y=parseInt(startposition_y)+parseInt(schriftgrad)+parseInt(abstand_zeilen);
        //alert(startposition_y);
    }
    var dataURL=canvas.toDataURL();
    var neues_bild=window.open(dataURL,'Druckansicht');
}

function Numsort (a, b) {
      return a - b;
}
